// Zaglavlje simul.h
#include <iostream>
#include <cstdlib>
#include <map>
#include <deque>
#include <cmath>
#include <algorithm>
#include <limits>
#include <cstring>

// Koristimo prostor imena STL biblioteke
using namespace std;

// Prostor imena simu4
namespace simul {
	// Klasa raspodela
	class raspodela {
		// Seme generatora slucajnih brojeva (GSB)
		unsigned int seme;
		// Multiplikator GSB
		unsigned int a;
		// Modulus GSB
		unsigned int m;
	public:
		// Konstruktor
		raspodela(unsigned int s = 1) :seme(s) {
			// Postavljamo vrednost multiplikatora
			a = 16807;
			// Postavljamo vrednost modulusa
			m = 2147483647;
		}
		// Lehmerov multiplikativni kongruentni generator
		double operator() () {
			seme = (a*seme) % (m + 1);
			return seme / (1.0*m);
		}
		// Uniformna raspodela
		double unif(double a, double b) {
			if (b>a)
				return a + (b - a)*(*this)();
			else {
				cerr << "Gornja granica mora da bude veca od donje" << endl;
				system("pause");
				exit(1);
			}
		}
		// Eksponencijalna raspodela
		double expo(double m) {
			if (m>0)
				return -m*log((*this)());
			else {
				cerr << "Ocekivanje mora da bude vece od nule" << endl;
				system("pause");
				exit(1);
			}
		}
		// Normalna raspodela
		double norm(double m, double s) {
			double z = 0.0;
			if (s>0) {
				for (int i = 0; i<12; i++)
					z += (*this)();
				return m + (z - 6)*s;
			}
			else {
				cerr << "Devijacija ne sme da bude manja ili jednaka nuli" << endl;
				system("pause");
				exit(1);
			}
		}
	};
	// Klasa funkcija
	struct funkcija {
		// Diskretna raspodela
		static double diskretna(double val, double x[], double y[], int n) {
			if (val >= 0.0 && val<x[n - 1]) {
				if (val<x[0]) return y[0];
				for (int i = 0; i<n - 1; i++) {
					if (val >= x[i] && val<x[i + 1])
						return y[i + 1];
				}
			}
			else {
				cerr << "Trazite vrednost funkcije van zadatog intervala" << endl;
				system("pause");
				exit(1);
			}
			return 0.0;
		}
		// Kontinualna raspodela
		static double kontinualna(double val, double x[], double y[], int n) {
			if (val >= x[0] && val<x[n - 1]) {
				for (int i = 0; i<n - 1; i++)
				if (x[i] == val) return y[i];
				for (int i = 0; i<n - 1; i++) {
					if (val >= x[i] && val<x[i + 1])
						return y[i] + (y[i + 1] - y[i]) / (x[i + 1] - x[i])*(val - x[i]);
				}
			}
			else {
				cerr << "Trazite vrednost funkcije van zadatog intervala" << endl;
				system("pause");
				exit(1);
			}
			return 0.0;
		}
	};
	/*
	class histogram {
		double ggpi;  // Gornja granica prvog intervala
		double si;    // Sirina intervala
		int bi;       // Broj intervala
		int *frekv;   // Frekvencije
		int frekv_of; // Frekvencija overflowa
		double sumaa; // Suma argumenata
		double sumaao;// Suma argumenata overflow vrednosti
		double srvr;  // Srednja vrednost
		double m2;
		int broj;     // Broj snimljenih vrednosti
	public:
		histogram(double ggpi, double si, int bi) :ggpi(ggpi), si(si), bi(bi), broj(0),
			sumaa(0.0), srvr(0.0), m2(0.0), sumaao(0.0), frekv_of(0) {
			if (bi <= 1) {
				cerr << "Histogram mora da ima 2 ili vise intervala" << endl;
				system("pause");
				exit(1);
			}
			if (si <= 0) {
				cerr << "Sirina intervala mora da bude pozitivni realni broj" << endl;
				system("pause");
				exit(1);
			}
			if (ggpi<0) {
				cerr << "Gornja granica prvog intervala mora da bude pozitivni realni broj" << endl;
				system("pause");
				exit(1);
			}
			// Alociramo fekvencije po intervalima
			frekv = new int[bi];
			// Inicijalizujemo frekvencije
			memset(frekv, 0, bi*sizeof(int));
		}
		~histogram() {
			delete[] frekv;
		}
		void operator()(double v) {
			// Brojimo ulaske u histogram
			broj++;
			// Nalazimo sumu argumenata
			sumaa += v;
			// Online srednja vrednost i devijacija
			double d = v - srvr;
			srvr += d / broj;
			m2 += d*(v - srvr);
			// Uvecavamo frekvencije za
			// prvi interval
			if (v >= 0.0&&v <= ggpi) {
				++frekv[0];
			}
			// overflow
			else if (v>ggpi + (bi - 1)*si) {
				++frekv_of;
				sumaao += v;
			}
			// ostale intervale
			else {
				for (int i = 0; i<(bi - 1); i++) {
					if (v>ggpi + i*si && v <= ggpi + (i + 1)*si) {
						++frekv[i + 1];
						break;
					}
				}
			}
		}
		inline void postavi_gornju_granicu_prvog_intervala(const double gg) {
			if (gg < 0) {
				cerr << "Gornja granica prvog intervala mora da bude pozitivni realni broj" << endl;
				system("pause");
				exit(1);
			}
			ggpi = gg;
		}
		inline void postavi_sirinu_intervala(const double s) {
			if (s <= 0) {
				cerr << "Sirina intervala mora da bude pozitivni realni broj" << endl;
				system("pause");
				exit(1);
			}
			si = s;
		}
		inline void postavi_broj_intervala(const int b) {
			if (b <= 1) {
				cerr << "Histogram mora da ima 1 ili vise intervala" << endl;
				system("pause");
				exit(1);
			}
			bi = b;
			frekv = new int[bi];
			memset(frekv, 0, bi*sizeof(int));
		}
		inline double vrati_sirinu_intervala() const {
			return si;
		}
		inline int vrati_broj_intervala() const {
			return bi;
		}
		inline double vrati_gornju_granicu_prvog_intervala() const {
			return ggpi;
		}
		inline double vrati_broj_ulaza_u_histogram() const {
			return broj;
		}
		inline double vrati_srednju_vrednost_histograma() const {
			return srvr;
		}
		inline double vrati_standardnu_devijaciju_histograma() {
			return sqrt(m2 / (broj - 1));
		}
		inline double vrati_sumu_argumenata_histograma() const {
			return sumaa;
		}
		double vrati_gornju_granicu_intervala(int n) {
			if (n<0 || n>bi - 1) {
				cerr << "Gornju granicu intervala mozete dobiti za sve intervale" << endl;
				system("pause");
				exit(1);
			}
			return ggpi + n*si;
		}
		double vrati_frekvenciju_intervala(int n) {
			if (n<0 || n>bi) {
				cerr << "Frekvenciju intervala mozete dobiti za sve intervale i overflow" << endl;
				system("pause");
				exit(1);
			}
			if (n == bi)
				return frekv_of;
			else
				return frekv[n];
		}
		double vrati_verovatnocu_intervala(int n) {
			if (n<0 || n>bi) {
				cerr << "Verovatnocu intervala mozete dobiti za sve intervale i overflow" << endl;
				system("pause");
				exit(1);
			}
			if (n == bi)
				return frekv_of / (1.0*broj);
			else
				return frekv[n] / (1.0*broj);
		}
		double vrati_umnozak_od_srednje_vrednosti_intervala(int n) {
			if (n<0 || n>bi - 1) {
				cerr << "Umnozak od srednje vrednosti intervala mozete dobiti za sve intervale" << endl;
				system("pause");
				exit(1);
			}
			return vrati_gornju_granicu_intervala(n) / vrati_srednju_vrednost_histograma();
		}
		double vrati_devijaciju_od_srednje_vrednosti_intervala(int n) {
			if (n<0 || n>bi - 1) {
				cerr << "Devijaciju od srednje vrednosti intervala mozete dobiti za sve intervale" << endl;
				system("pause");
				exit(1);
			}
			return (vrati_gornju_granicu_intervala(n) - vrati_srednju_vrednost_histograma()) / vrati_standardnu_devijaciju_histograma();
		}
		inline double vrati_prosecnu_vrednost_overflowa() {
			return sumaao / frekv[bi - 1];
		}
		void resetuj() {
			memset(frekv, 0, bi*sizeof(int));
			frekv_of = 0;
			broj = 0;
			sumaa = 0.0;
			sumaao = 0.0;
			srvr = 0.0;
			m2 = 0.0;
		}
	};*/
	// Klasa entiteta
	class entitet {
		// Omogucavamo klasi simulacija da pristupi privatnim clanovima klase entitet
		friend class simulacija;
		// Omogucavamo klasi red_cekanja da pristupi privatnim clanovima klase entitet
		friend class red_cekanja;
		// Omogucavamo klasi resurs da pristupi privatnim clanovima klase entitet
		friend class resurs;
		// Redni broj entiteta
		int id;
		// Buduci dogadjaj
		int naredni_dogadjaj;
		// Vreme nastupanja buduceg dogadjaja
		double vreme_nastupanja_dogadjaja;
		// Parametri entiteta
		double parametri[100];
		// Prioritet
		int prioritet;
	public:
		// Konstruktor
		entitet(int eid) :id(eid) { }
		// Vraca id entiteta
		int vrati_id() { return id; }
	public:
		// Postavlja i vraca parametar entiteta
		double& operator[](int n) {
			return parametri[n];
		}

		void postavi_parametar(int i, double v){ if (i>0 || i<100) parametri[i] = v; }
		double vrati_parametar(int i){ if (i>0 || i < 100) return parametri[i]; return 0; }

		// Postavi i vrati prioritet
		void postavi_prioritet(const int p) { prioritet = p; }
		const int vrati_prioritet() { return prioritet; }
	};
	//
	class statistike {
	private:
		// Ukupni, tekuci i maksimalni broj entiteta u resursu
		int broj, tekuci_broj, maks_broj;
		// Broj klijenata koji nisu cekali
		int broj_bez_cekanja;
		// Ukupno vreme za koje je resurs bio zauzet
		double ukupno_vreme;
		// Vreme za koje se entitet zadrzava u resursu
		double povrsina;
		// Poslednji trenutak promene stanja entiteta u resurs
		double vremenski_trenutak;
		// Vremenski trenuci promene stanja
		map<int, double> idvreme;
	public:
		statistike() : broj(0), tekuci_broj(0), maks_broj(0), broj_bez_cekanja(0),
			ukupno_vreme(0.0), povrsina(0.0), vremenski_trenutak(0.0){}
		void ulaz(const int id, double ti) {
			// Uvecamo broj entiteta koji su usli resurs
			broj++;
			// Prebrisana povrsina
			povrsina += (tekuci_broj++)*(ti - vremenski_trenutak);
			// Pamtimo trenutak poslednje promene broja zauzetih mesta
			vremenski_trenutak = ti;
			// Ukoliko je tekuci broj zauzetih mesta veci od maksimalnog
			// tekuci broj postaje maksimalni broj
			maks_broj = (tekuci_broj>maks_broj) ? tekuci_broj : maks_broj;
			// Pamtimo redni broj entiteta u resursu i trenutak ulaska entiteta u resurs
			idvreme[id] = ti;
		}
		void izlaz(const int id, double ti) {
			if (idvreme.find(id) != idvreme.end()) {
				double dt = ti - idvreme[id];
				// Ukoliko je vreme koje je entitet proveo u redu 0
				// uvecavamo broj entiteta koji nisu cekali u redu
				if (abs(dt)<numeric_limits<double>::epsilon()) broj_bez_cekanja++;
				// Ukupno vreme koje su entiteti proveli u salteru
				ukupno_vreme += dt;
				// Prebrisana povrsina
				povrsina += (tekuci_broj--)*(ti - vremenski_trenutak);
				// Pamtimo vreme ulaska entiteta u resurs
				vremenski_trenutak = ti;
				// Uklanjamo redni broj entiteta
				idvreme.erase(id);
			}
		}
		// Finisiramo statistike na kraju simulacije
		inline void finisiraj(double ti) {
			povrsina += tekuci_broj*(ti - vremenski_trenutak);
		}
		// Resetujemo statistike
		void resetuj() {
			broj = 0;
			tekuci_broj = 0;
			maks_broj = 0;
			broj_bez_cekanja = 0;
			ukupno_vreme = 0.0;
			povrsina = 0.0;
			vremenski_trenutak = 0.0;
			idvreme.clear();
		}
	public:
		inline int vrati_broj() const { return broj; }
		inline int vrati_tekuci_broj() const { return tekuci_broj; }
		inline int vrati_maksimalni_broj() const { return maks_broj; }
		inline int vrati_broj_bez_cekanja() const { return broj_bez_cekanja; }
		inline double vrati_ukupno_vreme() const { return ukupno_vreme; }
		inline double vrati_srednje_vreme() {
			return ukupno_vreme / (broj - tekuci_broj);
		}
		inline double vrati_srednje_vreme_bez_cekanja() {
			return ukupno_vreme / (broj - tekuci_broj - broj_bez_cekanja);
		}
		inline double vrati_srednji_broj(double sim_time) {
			return povrsina / sim_time;
		}
		inline double vrati_iskoriscenost(double sim_time, int broj_of_servers = 1) {
			return (vrati_srednji_broj(sim_time) / broj_of_servers)*100;
		}
		inline double vrati_ucesce_bez_cekanja() {
			return (100.0*broj_bez_cekanja) / broj;
		}
	};
	// Klasa simulacija
	class simulacija {
		// Brojac entiteta
		int eid;
		// Terminacioni brojac
		int tb;
		// Vreme simulacije
		double vreme_simulacije, apsolutno_vreme_simulacije;
		// Polje entiteta u LBD listi
		deque<entitet*> lista_nastupanja_entiteta;
		// Sortiranje LBD - Sortiranje izborom
		void sortiraj_listu_nastupanja() {
			stable_sort(lista_nastupanja_entiteta.begin(), lista_nastupanja_entiteta.end(), simulacija::uporedi_entitete);
		}
	public:
		// Konstruktor
		simulacija() :eid(1), tb(0), vreme_simulacije(0.0), apsolutno_vreme_simulacije(0.0) {}
		// Destruktor
		~simulacija() {
			// Uklanjamo presotale entitete iz LBD na kraju simulacije
			ocisti();
		}
		// Pravljenje entiteta
		entitet* napravi_entitet() {
			// Pravimo novi entitet
			return new entitet(eid++);
		}
		// Unistavanje entiteta
		void unisti_entitet(entitet *e, int b) {
			// Unistavamo entitet
			delete e;
			// Umanjujemo terminacioni brojac
			tb -= b;
		}
		// Rasporedjivanje dogadjaja
		void rasporedi(entitet* e, int dog, double vreme) {
			// Postavljamo dogadjaj
			e->naredni_dogadjaj = dog;
			// Postavljamo vreme nastupanja dogadjaja
			e->vreme_nastupanja_dogadjaja = vreme;
			// Smestamo entitet u listu
			lista_nastupanja_entiteta.push_back(e);
			// Sortiramo LBD
			sortiraj_listu_nastupanja();
		}
		// Izvrsavanje simulacije
		void izvrsi(int b) {
			entitet * tekuci;
			// Postavljamo terminacioni brojac
			tb = b;
			// Izvrsavamo simulaciju. Simulacija se zavrsava ukoliko
			// nema entiteta u LBD ili ukoliko je terminacioni brojac 0.
			do {
				// Vadimo prvi entitet iz liste. Taj entitet postaje tekuci entitet.
				tekuci = lista_nastupanja_entiteta.front();
				lista_nastupanja_entiteta.pop_front();
				// Faza 1: Azurirarmo vreme simulacije
				vreme_simulacije = tekuci->vreme_nastupanja_dogadjaja;
				// Faza 2: Izvrsavamo dogadjaj
				izvrsavanje_dogadjaja(tekuci->naredni_dogadjaj, tekuci);
			} while (!lista_nastupanja_entiteta.empty() && tb>0);
		}
		// Uklanjamo entitete iz LBD
		void ocisti() {
			// Uvecavamo apsolutno vreme simulacije
			apsolutno_vreme_simulacije += vreme_simulacije;
			// Resetujemo vreme simulacije
			vreme_simulacije = 0.0;
			for (deque<entitet*>::iterator it = lista_nastupanja_entiteta.begin();
				it != lista_nastupanja_entiteta.end();
				it++) delete *it;
			// Cistimo listu
			lista_nastupanja_entiteta.clear();
		}
		// Izvrsava dogadjaj
		void izvrsavanje_dogadjaja(int dog, entitet* e);
		// Vraca vreme simulacije
		double vrati_vreme_simulacije() { return vreme_simulacije; }
		double vrati_apsolutno_vreme_simulacije() { return apsolutno_vreme_simulacije + vreme_simulacije; }
		// Komparacija vremena nastupanja entiteta
		static bool uporedi_entitete(entitet* ea, entitet* eb) {
			return ea->vreme_nastupanja_dogadjaja < eb->vreme_nastupanja_dogadjaja;
		}
	};
	// Klasa FIFO red cekanja
	class red_cekanja {
		enum tip_reda {
			fifo, lifo
		};
	private:
		// Tip reda cekanja
		tip_reda tip;
		// Simulacija
		simulacija* psim;
		// Statistike
		statistike stat;
		// Polje pokazivaca na entitete
		deque<entitet*> red;
	public:
		// Konstruktor
	/*	red_cekanja(tip_reda tip) : tip(tip), psim(NULL) {}
		red_cekanja(tip_reda tip, simulacija* s) : tip(tip), psim(s) {}
		red_cekanja() : tip(fifo), psim(NULL) {}*/
		red_cekanja(simulacija* s) : tip(fifo), psim(s) {}

		// Smestamo entitet u red cekanja
		void ured(entitet* e) {
			// Smestamo entitet na kraj reda cekanja
			red.push_back(e);
			// Azuriramo statistike dolaskom entiteta
			if (e&&psim)
				stat.ulaz(e->id, psim->vrati_vreme_simulacije());
			else {
				cerr << "Nema objekta simulacije" << endl;
				system("pause");
				exit(1);
			}
		}
		// Vadimo entitet iz reda cekanja
		entitet* izred() {
			entitet *e = NULL;
			if (!red.empty()) {
				if (tip == fifo) {
					// Vracamo prvi entitet iz reda cekanja
					e = red.front();
					// Vadimo entitet iz reda cekanja
					red.pop_front();
				}
				/*else if (tip == lifo){
					// Vracamo prvi entitet iz reda cekanja
					e = red.back();
					// Vadimo entitet iz reda cekanja
					red.pop_back();
				}*/
				// Azuriramo statistike odlaskom entiteta
				if (e&&psim)
					stat.izlaz(e->id, psim->vrati_vreme_simulacije());
				else {
					cerr << "Nema objekta simulacije" << endl;
					system("pause");
					exit(1);
				}
			}
			else {
				cerr << "Nema entiteta u redu cekanja" << endl;
				system("pause");
				exit(1);
			}
			// Vraca entitet
			return e;
		}
		// Finisiraj statistike
		void finisiraj() {
			if (psim)
				stat.finisiraj(psim->vrati_vreme_simulacije());
			else {
				cerr << "Nema objekta simulacije" << endl;
				system("pause");
				exit(1);
			}
		}
		// Resetujemo statistike
		void resetuj() {
			stat.resetuj();
		}
		// Uklanjamo entitete i resetujemo statistike
		void ocisti() {
			stat.resetuj();
			for (deque<entitet*>::iterator it = red.begin(); it != red.end(); it++)
				delete *it;
			red.clear();
		}
		// Postavljamo simulaciju
		void postavi_simulaciju(simulacija* s) { psim = s; }
		// Vracamo velicinu reda cekanja
		int velicina() { return stat.vrati_tekuci_broj(); };
		// Vrati statistike
		const statistike& vrati_statistike() const { return stat; }
	};
	// Klasa resursa
	class resurs {
		// Simulacija
		simulacija* psim;
		// Statistike
		statistike stat;
		// Maksimalni broj  mesta u resursu
		int ukupni_broj_mesta;
	public:
		// Konstruktori
		/*resurs() :ukupni_broj_mesta(0), psim(NULL) {}
		resurs(int b) :ukupni_broj_mesta(b), psim(NULL) {}*/
		resurs(simulacija* s, int b) :ukupni_broj_mesta(b), psim(s) {}
		// Zauzima mesto u resursu
		void zauzmi(entitet* e) {
			if (stat.vrati_tekuci_broj()<ukupni_broj_mesta) {
				// Azuriramo statistike dolaskom entiteta
				if (psim)
					stat.ulaz(e->id, psim->vrati_vreme_simulacije());
				else {
					cerr << "Nema objekta simulacije" << endl;
					system("pause");
					exit(1);
				}
			}
			else {
				cerr << "Sva mesta u resursu su zauzeta" << endl;
				system("pause");
				exit(1);
			}
		}
		// Oslobadja mesto u resursu
		void oslobodi(entitet* e) {
			if (e&&stat.vrati_tekuci_broj()>0) {
				// Azuriramo statistike odlaskom entiteta
				if (e&&psim)
					stat.izlaz(e->id, psim->vrati_vreme_simulacije());
				else {
					cerr << "Nema objekta simulacije" << endl;
					system("pause");
					exit(1);
				}
			}
			else {
				cerr << "Nema entiteta u resursu" << endl;
				system("pause");
				exit(1);
			}
		}
		// Finisiraj statistike
		void finisiraj() {
			if (psim)
				stat.finisiraj(psim->vrati_vreme_simulacije());
			else {
				cerr << "Nema entiteta u redu cekanja" << endl;
				system("pause");
				exit(1);
			}
		}
		// Resetujemo statistike
		void resetuj() {
			stat.resetuj();
		}
		// Uklanjamo entitete i resetujemo statistike
		void ocisti() {
			stat.resetuj();
		}
		// Postavljamo simulaciju
		void postavi_simulaciju(simulacija* s) { psim = s; }
		// Postavlja i vraca broj mesta u resursu
		void postavi_broj_mesta(const int b) { ukupni_broj_mesta = b; }
		const int vrati_broj_mesta() const { return ukupni_broj_mesta; }
		// Raspolozivost resursa (ima makar jedno slobodno mesto u resursu)
		bool raspoloziv() { return (stat.vrati_tekuci_broj()<ukupni_broj_mesta); }
		// Vrati statistike
		const statistike& vrati_statistike() const { return stat; }
	};
}
